<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('Jobs', function (Blueprint $table) {
            $table->engine = 'InnoDB'; // Explicitly set InnoDB for foreign keys
            $table->bigIncrements('Job_id');
            $table->unsignedBigInteger('Company_id');
            $table->string('Title', 255);
            $table->text('Description');
            $table->string('Location', 255)->nullable();
            $table->decimal('Salary', 10, 2)->nullable();
            $table->enum('Job_type', ['full_time', 'part_time', 'contract', 'internship']);
            $table->enum('Status', ['open', 'closed', 'draft'])->default('draft');
            $table->timestamp('Created_at')->useCurrent();
            $table->timestamp('Updated_at')->useCurrent()->useCurrentOnUpdate();
            $table->foreign('Company_id')->references('Company_id')->on('Company_profiles')->onDelete('cascade');
            $table->index('Company_id', 'Idx_company_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('Jobs');
    }
};
